﻿using AZVIC.Ei8htPOS.BAL;
using AZVIC.Ei8htPOS.Entities;
using AZVIC.Ei8htPOS.POSRetail.Constants;
using AZVIC.Ei8htPOS.POSRetail.Controls.Loading;
using AZVIC.Ei8htPOS.POSRetail.Helpers;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;

namespace AZVIC.Ei8htPOS.POSRetail.Pages
{
    /// <summary>
    /// Interaction logic for PendingTransactions.xaml
    /// </summary>
    public partial class SuccessfulTransactions : Page
    {
        public SuccessfulTransactions()
        {
            InitializeComponent();
            LoadUserList();
            dtStartDate.SelectedDate = dtEndDate.SelectedDate = DateTime.Now;
            LoadCompletedTransactions(string.Empty, DateTime.Now, DateTime.Now, 'A', (cbUsers.SelectedValue == null ? Guid.Empty : Guid.Parse(cbUsers.SelectedValue.ToString())));
        }

        private void LoadUserList()
        {
            List<UserAccount> pbList = UserAccountBL.GetList(Guid.Empty, string.Empty, string.Empty, string.Empty, DateTime.MinValue, DateTime.MinValue);
            pbList = (from pb in pbList
                      where pb.UserRoleType.Trim().ToLower() != "user" && pb.IsActive
                      orderby pb.CreatedDate descending
                      select pb).ToList<UserAccount>();

            cbUsers.ItemsSource = pbList;
        }
        private void btnExport_Click(object sender, RoutedEventArgs e)
        {
            ExcelExportHelper.Export(gvCompletedTransactions, "CompletedTransactions");
        }

        private void LoadCompletedTransactions(string Keyword, DateTime StartDate, DateTime EndDate, char OrderFromFlag, Guid adminUserAccountID)
        {
            ProgressDialogResult result = ProgressDialog.Execute(Application.Current.MainWindow, string.Empty, (bw, we) =>
              {
                  List<Orders> pcList = OrdersBL.GetList(Guid.Empty, Guid.Empty, Keyword, StartDate, EndDate);
                  if (pcList != null && pcList.Count > 0)
                  {
                      pcList = pcList.Where(a => a.IsActive).ToList<Orders>();
                  }
                  string OrderedFrom = OrderFromFlag == 'A' ? "All" : (OrderFromFlag == 'P' ? "POS" : "Web");
                      pcList = (from pl in pcList
                                orderby pl.OrderNumber descending
                                where pl.PaymentStatus.ToLower() == "completed" && (adminUserAccountID == Guid.Empty || pl.AdminUserAccountID == adminUserAccountID)
                                select pl).ToList<Orders>();
                  gvCompletedTransactions.Dispatcher.BeginInvoke(new Action(() => gvCompletedTransactions.ItemsSource = pcList));
              });
        }

        private void btnSearch_Click(object sender, RoutedEventArgs e)
        {
            LoadCompletedTransactions(txtSearch.Text.Trim(), dtStartDate.SelectedDate != null ? dtStartDate.SelectedDate.Value : DateTime.MinValue,
                dtEndDate.SelectedDate != null ? dtEndDate.SelectedDate.Value : DateTime.MinValue, 'A', (cbUsers.SelectedValue == null ? Guid.Empty : Guid.Parse(cbUsers.SelectedValue.ToString())));
        }

        private void gvCompletedTransactions_MouseDoubleClick(object sender, MouseButtonEventArgs e)
        {
            if (sender != null)
            {
                if (gvCompletedTransactions != null && gvCompletedTransactions.SelectedItems != null && gvCompletedTransactions.SelectedItems.Count == 1)
                {
                    DataGridRow dgr = gvCompletedTransactions.ItemContainerGenerator.ContainerFromItem(gvCompletedTransactions.SelectedItem) as DataGridRow;
                    Orders curOrders = dgr.DataContext as Orders;
                    if (curOrders.InvoiceNo.Trim().Length != 0)
                    {
                        Helper.ReceiptPrintHelper Obj = new Helper.ReceiptPrintHelper();
                        Obj.PrintReceipt(curOrders);
                    }
                    else
                        MessageBox.Show("Please Generate the Invoice in CMS and then try again.", "Ei8ht POS", MessageBoxButton.OK, MessageBoxImage.Error, MessageBoxResult.OK);
                }
            }
        }

        private void Print_Click(object sender, RoutedEventArgs e)
        {
            Button SelectedTransaction = sender as Button;
            DataGridRow dgr = GetParent(SelectedTransaction);
            Orders curOrders = dgr.DataContext as Orders;
            if (curOrders.InvoiceNo.Trim().Length != 0)
            {
                Helper.ReceiptPrintHelper Obj = new Helper.ReceiptPrintHelper();
                Obj.PrintReceipt(curOrders);
            }
            else
                MessageBox.Show("Please Generate the Invoice in website and then try again.", "Ei8ht POS", MessageBoxButton.OK, MessageBoxImage.Error, MessageBoxResult.OK);
        }

        private DataGridRow GetParent(DependencyObject dep)
        {
            DependencyObject Obj = null;
            if (dep.GetType() == typeof(DataGridRow))
            {
                Obj = dep as DataGridRow;
            }
            else
            {
                Obj = GetParent(VisualTreeHelper.GetParent(dep));
            }
            return Obj as DataGridRow;
        }

        private void Void_Click(object sender, RoutedEventArgs e)
        {
            if (AppSession.CurrentAdminUser.UserRoleType.ToLower().Equals("superadmin"))
            {
                if (App.ConfirmationDialog("Do you want to void the transaction", "Ei8ht POS"))
                {
                    Button SelectedTransaction = sender as Button;
                    DataGridRow dgr = GetParent(SelectedTransaction);
                    Orders curOrders = dgr.DataContext as Orders;
                    curOrders.OrderStatus = "Canceled";
                    OrdersBL.Save(curOrders);

                    if ((!string.IsNullOrEmpty(txtSearch.Text)) || (dtStartDate.SelectedDate != null) || (dtEndDate.SelectedDate != null))
                        LoadCompletedTransactions(txtSearch.Text.Trim(), dtStartDate.SelectedDate != null ? dtStartDate.SelectedDate.Value : DateTime.MinValue,
                           dtEndDate.SelectedDate != null ? dtEndDate.SelectedDate.Value : DateTime.MinValue, 'A', (cbUsers.SelectedValue == null ? Guid.Empty : Guid.Parse(cbUsers.SelectedValue.ToString())));
                    else
                        LoadCompletedTransactions(string.Empty, DateTime.Now, DateTime.Now, 'A', (cbUsers.SelectedValue == null ? Guid.Empty : Guid.Parse(cbUsers.SelectedValue.ToString())));
                }
            }
            else
            {
                MessageBox.Show("You don't have permission to void a transaction. Please contact the administrator");
            }
        }

        
    }
}
